function [model] = plda_twoCov_train22(numIter,train_data,train_labels,opt)

% trains the plda two covariance model and returns the model
% numIter : number of iterations used to train plda model
% train_data : training feature matrix in the form nxp where n represents
%              the number of datapoints and p represents the features
% train_labels : labels correspoinding to each datapoint in the train_data.
%                Of the form nx1
% opt : takes values 1,2 and 3 - 1 for 1v1, 2 for 1v3 and 3 for 1v9

addpath('./functions_parallel/two-cov/');
rng(0);
if opt==1   % train set for 1v1
    train_data=train_data;
    train_labels=train_labels;
    
elseif opt==2 % train set for 1v3
    
    aa=randperm(size(train_data,1)); % randomise order of data points in the enrolment dataset
    
    train_data=train_data(aa,:);
    train_labels= train_labels(aa);
    
     [GroupId,~,index_j]=unique(train_labels);
    T=arrayfun(@(y) train_data(index_j==y,:),1:length(GroupId),'UniformOutput',false); % cell array where each cell contains cartridge cases fired from a particular gun
    
       
    combsubset = select_unique_sets(10,30,3);
    combsubset1 = select_unique_sets(9,30,3);
    combsubset2 = select_unique_sets(8,30,3);
    combsubset3 = select_unique_sets(7,30,3);
    
    Y=cellfun(@(y)size(y,1), T);
   AW=[]; GrId=[];
    for b=1:30
        mask=arrayfun(@(y)y==10,Y);
        T1(mask)=cellfun(@(y) y(combsubset(b,:),:), T(mask),'UniformOutput',false); %set of 1st 3 cartridge cases-shuffled - not in order
        mask1=arrayfun(@(y)y==9,Y);
        T1(mask1)=cellfun(@(y) y(combsubset1(b,:),:), T(mask1),'UniformOutput',false);
        mask2=arrayfun(@(y)y==8,Y);
        T1(mask2)=cellfun(@(y) y(combsubset2(b,:),:), T(mask2),'UniformOutput',false);
        mask3=arrayfun(@(y)y==7,Y);
        T1(mask3)=cellfun(@(y) y(combsubset3(b,:),:), T(mask3),'UniformOutput',false);
        T1_m=cellfun(@(y) mean(y,1), T1,'UniformOutput',false);
        AB=cat(1,T1_m{:});
        GrId=[GrId;GroupId];
        AW=[AW;AB];
    end
    
    train_data=[train_data; AW];
    train_labels=[train_labels;GrId];
    
    
    
elseif opt==3 % train set for 1v9
    
    gun_nos_train=unique(train_labels);
    SS_data=[];SS_lab=[];
    
    parfor (in=1:length(gun_nos_train),29)
        instance_lab=gun_nos_train(in);
        SS_id=find_logical(train_labels==instance_lab);
        AD=nchoosek(SS_id,9); % each combination set is represented by a row
        for it=1:size(AD,1)
            ax=mean(train_data(AD(it,:),:),1);
            SS_data=[SS_data;ax];
            SS_lab=[SS_lab;instance_lab];
        end
        
    end
    
    
    train_data=[train_data;SS_data];
    train_labels=[train_labels;SS_lab];
    
else
    error('Wrong opt input. Please select a value between 1 to 3.');
    
end

matrixID = create_incidence_matrix(train_labels);

% Sort persons according to the number of samples
numSessions = sum(matrixID);
[junk,I] = sort(numSessions);
matrixID = matrixID(:,I);


[model stats] = two_cov_initialize(train_data', matrixID);
for i=1:numIter
    model = two_cov_em(matrixID, model, stats);
end
end

